
/// <reference name="MicrosoftAjaxTimer.debug.js" />
/// <reference name="MicrosoftAjaxWebForms.debug.js" />
/// <reference name="AjaxControlToolkit.ExtenderBase.BaseScripts.js" assembly="AjaxControlToolkit" />

Type.registerNamespace('ImageAnimation');

ImageAnimation.ImageAnimationBehavior = function(element) {
    ImageAnimation.ImageAnimationBehavior.initializeBase(this, [element]);
    this._onLoad = null;
    this._onLoadHandler = null;
}
ImageAnimation.ImageAnimationBehavior.prototype = {
    initialize : function() {
        ImageAnimation.ImageAnimationBehavior.callBaseMethod(this, 
                                                                'initialize');
        var element = this.get_element();
        if (element) 
         {
            this._onLoadHandler = Function.createDelegate(this, 
                                                            this.OnLoad);
            $addHandler(element, 'load', this._onLoadHandler);
        }
    },

    dispose : function() {
        ImageAnimation.ImageAnimationBehavior.callBaseMethod(this, 'dispose');
        
        var element = this.get_element();
        if (element) {
            if (this._onLoadHandler) {
                $removeHandler(element, 'load', this._onLoadHandler);
                this._onLoadHandler = null;
            }
        }

        this._onLoad = null;
        
    },
    get_OnLoad : function() {
        return this._onLoad ? this._onLoad.get_json() : null;
    },
    set_OnLoad : function(value) {
        if (!this._onLoad) {
            this._onLoad = new AjaxControlToolkit.Animation.GenericAnimationBehavior(this.get_element());
            this._onLoad.initialize();
        }
        this._onLoad.set_json(value);
        this.raisePropertyChanged('OnLoad');
    },
    get_OnLoadBehavior : function() {
        return this._onLoad;
    },
    OnLoad : function() {
        if (this._onLoad) {
            this._onLoad.play();
        }
    }
}
ImageAnimation.ImageAnimationBehavior.registerClass(
                    'ImageAnimation.ImageAnimationBehavior', 
                    AjaxControlToolkit.BehaviorBase);
